//
//  MCStageSyncOperation.h
//  MCStageSync
//
//  Created by Mark Onyschuk on 15/05/08.
//  Copyright 2008 Marketcircle, Inc.. All rights reserved.
//

#import <Foundation/Foundation.h>


@class MCStageSyncDaemon, MCClientStage, MCPDataStore, MCSQLiteStore, MCExportRuleManager;
@class MCTrackedProcess;
@class MCPFetchSpecification, MCPObject, MCPGenericObject;

@interface MCStageSyncOperation : NSObject {

	MCClientStage *stage;
	MCPDataStore *serverStore;
	MCSQLiteStore *clientStore;
	MCTrackedProcess *trackedProcess;

	NSArray *externalJoinEntities;
	NSString *notificationIdentifier;
}

@property (nonatomic, retain) MCClientStage *stage;
@property (nonatomic, retain) MCPDataStore *serverStore;
@property (nonatomic, retain) MCSQLiteStore *clientStore;

@property (nonatomic, copy) NSString *notificationIdentifier;

- (id)initWithStage:(MCClientStage *)aStage;

- (id)run;
- (NSArray *)externalJoinEntities;

- (void)logDuration:(NSDate *)startDate taskDescription:(NSString *)description;
- (NSString *)stateDescription;

- (void)sendSyncFinishedNotification;

- (void)addLinkedObject:(MCPObject *)linked toRecentHistoryForObject:(MCPObject *)source /*redundant:(BOOL)flag*/;
- (void)addLinkedObject:(MCPObject *)linked toRecentHistoryForObjects:(NSArray *)sources /*redundant:(BOOL)flag*/;
- (void)addLinkedObjects:(NSArray *)linked toRecentHistoryForObject:(MCPObject *)source /*redundant:(BOOL)flag*/;

- (NSArray *)recentHistoryForSourceTable:(NSString *)source destinationTable:(NSString *)dest primaryKeyValue:(NSNumber *)pKey;
- (NSArray *)recentHistoryForObject:(MCPObject *)object destinationTable:(NSString *)dest;

// destinationTable can be nil if you want to remove all history; otherwise removes history for the specified table
- (void)removeRecentHistoryForSourceTable:(NSString *)source destinationTable:(NSString *)dest primaryKeyValue:(NSNumber *)pKey;
- (void)removeRecentHistoryForObject:(MCPObject *)object destinationTable:(NSString *)dest;

// These return the affected source objects, if they can be found
- (NSArray *)removeRecentHistoryWithLinkedObjectID:(id)linkedID destinationTable:(NSString *)dest;
- (NSArray *)removeLinkedObjectFromRecentHistory:(MCPObject *)linked;

- (void)removeDestination:(NSNumber *)destionationID destinationTable:(NSString *)dest fromRecentHistoryForObject:(MCPObject *)source; // dest is mandatory
- (void)removeLinkedObject:(MCPObject *)linked fromRecentHistoryForObject:(MCPObject *)source;
- (void)removeLinkedObjects:(NSArray *)linked fromRecentHistoryForObject:(MCPObject *)source;

+ (MCPFetchSpecification *)fetchSpecForObject:(MCPGenericObject *)object attributeName:(NSString *)name sortAttribute:(NSString *)sortAttribute;

@end


@class BDQualifier;

@interface NSSet (MCSetQualifying)

- (NSSet *)filteredSetUsingQualifier:(BDQualifier *)qualifier;

@end

@interface NSMutableArray (MCMutableArrayQualifying)

- (void)filterUsingQualifier:(BDQualifier *)qualifier;

@end

@interface NSMutableSet (MCSetQualifying)

- (void)filterUsingQualifier:(BDQualifier *)qualifier;

@end


#if MAC_OS_X_VERSION_MAX_ALLOWED <= MAC_OS_X_VERSION_10_4
@interface NSSet (MCTigerBackwardCompatibility)

- (NSSet *)filteredSetUsingPredicate:(NSPredicate *)predicate;

@end

#endif
